(* Abstract Syntax Tree *)

type op = 
    Add | Sub | Mult | Div | Mod 
  | Caret 
  | And | Or
  | Eq | Neq | Lt | Lte | Gt | Gte
  | Cons | Append

type uop = Neg | Not 

type expr =
    VoidLit
  | NumLit of float
  | StringLit of string
  | BoolLit of bool
  | ListLit of expr list
  | DictLit of (expr * expr) list
  | FunLit of string list * expr
  | Val of string
  | Binop of expr * op * expr
  | Unop of uop * expr
  | Assign of string * expr
  | Call of expr * expr list
  | Element of string * expr
  | Block of expr list
  | If of (expr * expr) list * expr
  | NoExpr

type program = expr list

type pType = 
    T of string
  | TAny
  | TNum
  | TString
  | TBool
  | TVoid
  | TFun of funcType
  | TList of pType
  | TDict of pType * pType
and funcType = pType list * pType

type aexpr =
    AVoidLit of pType
  | ANumLit of float * pType
  | AStringLit of string * pType
  | ABoolLit of bool * pType
  | AListLit of aexpr list * pType
  | ADictLit of (aexpr * aexpr) list * pType
  | AFunLit of string list * aexpr * pType
  | AVal of string * pType
  | ABinop of aexpr * op * aexpr * pType
  | AUnop of uop * aexpr * pType
  | AAssign of string * pType * aexpr * pType
  | ACall of aexpr * aexpr list * pType
  | AElement of string * aexpr * pType
  | ABlock of aexpr list * pType
  | AIf of (aexpr * aexpr) list * aexpr * pType
